package ru.yandex.autotests.directapi.model.finances;

import com.google.common.primitives.Ints;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 16.10.13
 * Time: 19:56
 * To change this template use File | Settings | File Templates.
 */
public class PayCampElementMap<T> extends ModelBeanMap<PayCampElementMap> {
    private static final String PAY_CAMP_ELEMENT = "PayCampElement";

    public static final String CAMPAIGN_ID = "campaignID";
    public static final String SUM = "sum";
    public static final String CURRENCY = "currency";

    public PayCampElementMap(String packageName) {
        super(packageName, PAY_CAMP_ELEMENT);
    }

    public PayCampElementMap(T payCampObject) {
        super();
        setBean(payCampObject);
    }

    public PayCampElementMap withCampaignID(Integer campaignID) {
        put(CAMPAIGN_ID, campaignID);
        return this;
    }

    public PayCampElementMap withCampaignID(Long campaignID) {
        return withCampaignID(Ints.checkedCast(campaignID));
    }

    public PayCampElementMap withSum(Float sum) {
        put(SUM, sum);
        return this;
    }

    public PayCampElementMap withSum(Money sum) {
        put(SUM, sum.floatValue());
        return this;
    }

    public PayCampElementMap withCurrency(String currency) {
        put(CURRENCY, currency);
        return this;
    }

    public PayCampElementMap withCurrency(Currency currency) {
        if (currency != null) {
            put(CURRENCY, currency.toString());
        }
        return this;
    }
}
