package ru.yandex.autotests.directapi.model.finances;

import java.lang.reflect.Array;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.beanutils.BeanMap;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by semkagtn on 02.09.15.
 */
public class PayCampaignsByCardInfoMap extends ModelBeanMap<PayCampaignsByCardInfoMap> {

    private static final String PAY_CAMPAIGNS_BY_CARD_INFO = "PayCampaignsByCardInfo";

    public static final String PAY_METHOD_ID = "payMethodID";
    public static final String CUSTOM_TRANSACTION_ID = "customTransactionID";
    public static final String PAYMENTS = "payments";
    public static final String CURRENCY = "currency";
    public static final String VERSION = "version";

    public static final int CUSTOM_TRANSACTION_ID_LENGTH = 32;

    public PayCampaignsByCardInfoMap(String packageName) {
        super(packageName, PAY_CAMPAIGNS_BY_CARD_INFO);
    }

    public PayCampaignsByCardInfoMap(Object payCampaignsInfo) {
        super();
        setBean(payCampaignsInfo);
    }

    public PayCampaignsByCardInfoMap withPayMethodID(String payMethodID) {
        this.put(PAY_METHOD_ID, payMethodID);
        return this;
    }

    public PayCampaignsByCardInfoMap withCustomTransactionID(String customTransactionID) {
        this.put(CUSTOM_TRANSACTION_ID, customTransactionID);
        return this;
    }

    public PayCampaignsByCardInfoMap withVersion(String version) {
        this.put(VERSION, version);
        return this;
    }

    public PayCampaignsByCardInfoMap withPayments(PayCampElementMap... payments) {
        this.put(PAYMENTS, payments != null
                ? Stream.of(payments)
                .map(BeanMap::getBean)
                .collect(Collectors.toList())
                .toArray((Object[]) Array.newInstance(
                        new PayCampElementMap(getBean().getClass().getPackage().getName())
                                .getBean().getClass(), 0))
                : null);
        return this;
    }
}
