package ru.yandex.autotests.directapi.model.finances;

import java.lang.reflect.Array;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 26.12.13
 * Time: 11:00
 * To change this template use File | Settings | File Templates.
 */
public class PayCampaignsInfoMap<T> extends ModelBeanMap<PayCampaignsInfoMap> {

    private static final String PAY_CAMPAIGNS_INFO = "PayCampaignsInfo";

    public static final String PAYMENTS = "payments";
    public static final String CONTRACT_ID = "contractID";
    public static final String PAY_METHOD = "payMethod";

    public PayCampaignsInfoMap(String packageName) {
        super(packageName, PAY_CAMPAIGNS_INFO);
    }

    public PayCampaignsInfoMap(T payCampaignsInfo) {
        super();
        setBean(payCampaignsInfo);
    }

    public PayCampaignsInfoMap withPayMethod(String payMethod) {
        this.put((PAY_METHOD), payMethod);
        return this;
    }

    public PayCampaignsInfoMap withContractID(String contractID) {
        this.put((CONTRACT_ID), contractID);
        return this;
    }

    public PayCampaignsInfoMap withPayments(PayCampElementMap... payCampElements) {
        this.put((PAYMENTS), null);
        if (payCampElements != null) {
            this.put((PAYMENTS),
                    convert(payCampElements, new BeanMapToBeanConverter<>())
                            .toArray((Object[]) Array.newInstance(
                                    new PayCampElementMap(getBean().getClass().getPackage().getName())
                                            .getBean().getClass(), 0)));

        }
        return this;
    }
}
