package ru.yandex.autotests.directapi.model.finances;

import com.google.common.primitives.Ints;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 16.10.13
 * Time: 19:56
 * To change this template use File | Settings | File Templates.
 */
public class PaymentMap<T> extends ModelBeanMap<PaymentMap> {
    private static final String PAYMENT = "Payment";

    public static final String ACCOUNT_ID = "accountID";
    public static final String AMOUNT = "amount";
    public static final String ORIGIN = "origin";
    public static final String CURRENCY = "currency";
    public static final String CONTRACT = "contract";

    public PaymentMap(String packageName) {
        super(packageName, PAYMENT);
    }

    public PaymentMap(T payment) {
        super();
        setBean(payment);
    }

    public PaymentMap withAccountID(Integer accountID) {
        put(ACCOUNT_ID, accountID);
        return this;
    }

    public PaymentMap withAccountID(long accountId) {
        put(ACCOUNT_ID, Ints.checkedCast(accountId));
        return this;
    }

    public PaymentMap withAmount(Float amount) {
        put(AMOUNT, amount);
        return this;
    }

    public PaymentMap withAmount(Money amount) {
        put(AMOUNT, amount.floatValue());
        return this;
    }

    public PaymentMap withContract(String contract) {
        put(CONTRACT, contract);
        return this;
    }

    public PaymentMap withCurrency(Currency currency) {
        if (currency == null) {
            put(CURRENCY, null);
        } else {
            put(CURRENCY, currency.name());
        }
        return this;
    }

    public PaymentMap withCurrency(String currency) {
        put(CURRENCY, currency);
        return this;
    }


    public PaymentMap withOrigin(String origin) {
        put(ORIGIN, origin);
        return this;
    }
}
