package ru.yandex.autotests.directapi.model.finances;

import java.lang.reflect.Array;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 26.12.13
 * Time: 11:00
 * To change this template use File | Settings | File Templates.
 */
public class TransferMoneyInfoMap<T> extends ModelBeanMap<TransferMoneyInfoMap> {

    private static final String TRANSFER_MONEY_INFO = "TransferMoneyInfo";

    public static final String FROM_CAMPAIGNS = "fromCampaigns";
    public static final String TO_CAMPAIGNS = "toCampaigns";

    public TransferMoneyInfoMap(String packageName) {
        super(packageName, TRANSFER_MONEY_INFO);
    }

    public TransferMoneyInfoMap(T transferMoneyInfo) {
        super();
        setBean(transferMoneyInfo);
    }

    public TransferMoneyInfoMap withFromCampaigns(PayCampElementMap... payCampElements) {
        this.put((FROM_CAMPAIGNS), null);
        if (payCampElements != null) {
            this.put((FROM_CAMPAIGNS),
                    convert(payCampElements, new BeanMapToBeanConverter())
                            .toArray((Object[]) Array.newInstance(
                                    new PayCampElementMap(getBean().getClass().getPackage().getName())
                                            .getBean().getClass(), 0)));

        }
        return this;
    }

    public TransferMoneyInfoMap withToCampaigns(PayCampElementMap... payCampElements) {
        this.put((TO_CAMPAIGNS), null);
        if (payCampElements != null) {
            this.put((TO_CAMPAIGNS),
                    convert(payCampElements, new BeanMapToBeanConverter())
                            .toArray((Object[]) Array.newInstance(
                                    new PayCampElementMap(getBean().getClass().getPackage().getName())
                                            .getBean().getClass(), 0)));

        }
        return this;
    }
}
