package ru.yandex.autotests.directapi.model.finances.sharedaccount;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class AccountDayBudgetInfoMap<T> extends ModelBeanMap<AccountDayBudgetInfoMap> {
    private static final String ACCOUNT_DAY_BUDGET_INFO = "AccountDayBudgetInfo";
    public static final String AMOUNT = "amount";
    public static final String SPEND_MODE = "spendMode";

    public AccountDayBudgetInfoMap(String packageName) {
        super(packageName, ACCOUNT_DAY_BUDGET_INFO);
    }

    public AccountDayBudgetInfoMap(T accountManagementRequest) {
        super();
        setBean(accountManagementRequest);
    }

    public AccountDayBudgetInfoMap withAmount(Float amount) {
        put(AMOUNT, amount);
        return this;
    }

    public AccountDayBudgetInfoMap withSpendMode(String spendMode) {
        put(SPEND_MODE, spendMode);
        return this;
    }
}
