package ru.yandex.autotests.directapi.model.finances.sharedaccount;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.apiclient.methods.Action;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by mariabye on 07.02.14.
 */
public class AccountManagementRequestMap<T> extends ModelBeanMap<AccountManagementRequestMap> {

    private static final String ACCOUNT_MANAGEMENT_REQUEST = "AccountManagementRequest";

    public static final String LOGIN = "login";
    public static final String ACTION = "action";
    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String PAYMENTS = "payments";
    public static final String TRANSFERS = "transfers";
    public static final String ACCOUNTS = "accounts";
    public static final String PAY_METHOD_ID = "payMethodID";
    public static final String CUSTOM_TRANSACTION_ID = "customTransactionID";
    public static final String VERSION = "version";

    public static final int CUSTOM_TRANSACTION_ID_LENGTH = 32;

    public AccountManagementRequestMap(String packageName) {
        super(packageName, ACCOUNT_MANAGEMENT_REQUEST);
    }

    public AccountManagementRequestMap(T accountManagementRequest) {
        super();
        setBean(accountManagementRequest);
    }

    public AccountManagementRequestMap withAction(Action action) {
        put(ACTION, action.getAction());
        return this;
    }

    public AccountManagementRequestMap withPayments(PaymentMap... paymentMaps) {
        put(PAYMENTS, convert(paymentMaps, new BeanMapToBeanConverter<>())
                .toArray(new PaymentMap(super.getPackageName()).emptyBeanArray()));
        return this;
    }

    public AccountManagementRequestMap withSelectionCriteria(AccountSelectionCriteriaMap accountSelectionCriteriaMap) {
        put(SELECTION_CRITERIA, accountSelectionCriteriaMap.getBean());
        return this;
    }

    public AccountManagementRequestMap withAccounts(AccountMap... accountMaps) {
        Object[] params = convert(accountMaps, new BeanMapToBeanConverter<AccountMap, Object>()).toArray();
        put(ACCOUNTS, convert(accountMaps, new BeanMapToBeanConverter<>())
                .toArray(new AccountMap(super.getPackageName()).emptyBeanArray()));
        return this;
    }

    public AccountManagementRequestMap withTransfers(TransferMap... transferMaps) {
        Object[] params = convert(transferMaps, new BeanMapToBeanConverter<TransferMap, Object>()).toArray();
        put(TRANSFERS, convert(transferMaps, new BeanMapToBeanConverter<>())
                .toArray(new TransferMap(super.getPackageName()).emptyBeanArray()));
        return this;
    }

    public AccountManagementRequestMap withPayMethodId(String payMethodId) {
        this.put(PAY_METHOD_ID, payMethodId);
        return this;
    }

    public AccountManagementRequestMap withVersion(String version) {
        this.put(VERSION, version);
        return this;
    }

    public AccountManagementRequestMap withCustomTransactionId(String customTransactionId) {
        this.put(CUSTOM_TRANSACTION_ID, customTransactionId);
        return this;
    }
}
