package ru.yandex.autotests.directapi.model.finances.sharedaccount;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.model.campaigns.EmailNotificationInfoMap;
import ru.yandex.autotests.directapi.model.campaigns.SmsNotificationInfoMap;

/**
 * Created by mariabye on 07.02.14.
 */
public class AccountMap<T> extends ModelBeanMap<AccountMap> {

    private static final String ACCOUNT = "Account";
    public static final String SMS_NOTIFICATION = "smsNotification";
    public static final String EMAIL_NOTIFICATION = "emailNotification";
    public static final String ACCOUNT_ID = "accountID";
    public static final String ACCOUNT_DAY_BUDGET = "accountDayBudget";
    public static final String AMOUNT = "amount";
    public static final String AMOUNT_AVAILABLE_FOR_TRANSFER = "amountAvailableForTransfer";
    public static final String CURRENCY = "currency";
    public static final String LOGIN = "login";
    public static final String DISCOUNT = "discount";

    public AccountMap(String packageName) {
        super(packageName, ACCOUNT);
    }

    public AccountMap(T accountManagementRequest) {
        super();
        setBean(accountManagementRequest);
    }

    public AccountMap withSmsNotification(SmsNotificationInfoMap smsNotificationInfoMap) {
        put(SMS_NOTIFICATION, smsNotificationInfoMap.getBean());
        return this;
    }

    public AccountMap withEmailNotification(EmailNotificationInfoMap emailNotificationInfoMap) {
        if (emailNotificationInfoMap != null) {
            put(EMAIL_NOTIFICATION, emailNotificationInfoMap.getBean());
        } else {
            put(EMAIL_NOTIFICATION, null);
        }
        return this;
    }

    public AccountMap withAccountID(int accountID) {
        put(ACCOUNT_ID, accountID);
        return this;
    }

    public AccountMap withAmount(Float amount) {
        put(AMOUNT, amount);
        return this;
    }

    public AccountMap withAmountAvailableForTransfer(Float amountAvailableForTransfer) {
        put(AMOUNT_AVAILABLE_FOR_TRANSFER, amountAvailableForTransfer);
        return this;
    }

    public AccountMap withCurrency(Currency currency) {
        if (currency != null) {
            put(CURRENCY, currency.toString());
        }
        return this;
    }

    public AccountMap withDiscount(Float discount) {
        put(DISCOUNT, discount);
        return this;
    }

    public AccountMap withLogin(String login) {
        put(LOGIN, login);
        return this;
    }

    public AccountMap withAccountDayBudget(AccountDayBudgetInfoMap accountDayBudgetInfoMap) {
        if (accountDayBudgetInfoMap != null) {
            put(ACCOUNT_DAY_BUDGET, accountDayBudgetInfoMap.getBean());
        } else {
            put(ACCOUNT_DAY_BUDGET, null);
        }
        return this;
    }
}
