package ru.yandex.autotests.directapi.model.finances.sharedaccount;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by mariabye on 07.02.14.
 */
public class AccountSelectionCriteriaMap<T> extends ModelBeanMap<AccountSelectionCriteriaMap> {
    private static final String ACCOUNT_SELECTION_CRITERIA = "AccountSelectionCriteria";
    public static final String LOGINS = "logins";
    public static final String ACCOUNT_IDS = "accountIDS";

    public AccountSelectionCriteriaMap(String packageName) {
        super(packageName, ACCOUNT_SELECTION_CRITERIA);
    }

    public AccountSelectionCriteriaMap(T accountSelectionCriteria) {
        super();
        setBean(accountSelectionCriteria);
    }

    public AccountSelectionCriteriaMap withLogins(String... logins) {
        put(LOGINS, logins);
        return this;
    }

    public AccountSelectionCriteriaMap withAccountIDs(int... accountIDs) {
        put(ACCOUNT_IDS, accountIDs);
        return this;
    }
}
