package ru.yandex.autotests.directapi.model.finances.sharedaccount;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by mariabye on 07.02.14.
 */
public class EnableSharedAccountRequestMap<T> extends ModelBeanMap<EnableSharedAccountRequestMap> {

    private static final String ENABLE_SHARED_ACCOUNT_REQUEST = "EnableSharedAccountRequest";
    public static final String LOGIN = "login";

    public EnableSharedAccountRequestMap(String packageName) {
        super(packageName, ENABLE_SHARED_ACCOUNT_REQUEST);
    }

    public EnableSharedAccountRequestMap(T enableSharedAccountRequest) {
        super();
        setBean(enableSharedAccountRequest);
    }

    public EnableSharedAccountRequestMap withLogins(String login) {
        put(LOGIN, login);
        return this;
    }
}
