package ru.yandex.autotests.directapi.model.finances.sharedaccount;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created by mariabye on 07.02.14.
 */
public class TransferMap<T> extends ModelBeanMap<TransferMap> {
    private static final String TRANSFER = "Transfer";

    public static final String FROM_ACCOUNT_ID = "fromAccountID";
    public static final String TO_ACCOUNT_ID = "toAccountID";
    public static final String AMOUNT = "amount";
    public static final String CURRENCY = "currency";

    public TransferMap(String packageName) {
        super(packageName, TRANSFER);
    }

    public TransferMap(T transfer) {
        super();
        setBean(transfer);
    }

    /*public T[] emptyArray(){
        return (T[]) Array.newInstance(new TransferMap(super.getPackageName()).getBean().getClass(), 0);
    }*/
    public TransferMap withFromAccountID(int accountID) {
        put(FROM_ACCOUNT_ID, accountID);
        return this;
    }

    public TransferMap withToAccountID(int accountID) {
        put(TO_ACCOUNT_ID, accountID);
        return this;
    }

    public TransferMap withAmount(float amount) {
        put(AMOUNT, amount);
        return this;
    }

    public TransferMap withCurrency(Currency currency) {
        if (currency == null) {
            put(CURRENCY, null);
        } else {
            put(CURRENCY, currency.name());
        }
        return this;
    }

    public TransferMap withCurrency(String currency) {
        put(CURRENCY, currency);
        return this;
    }
}
