package ru.yandex.autotests.directapi.model.forecast;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created with IntelliJ IDEA.
 * User: ginger
 * Date: 25.11.13
 * Time: 16:39
 * To change this template use File | Settings | File Templates.
 */
public class NewForecastInfoExtendedMap<T> extends ModelBeanMap<NewForecastInfoExtendedMap> {
    //region Fields
    private static final String NEW_FORECAST_INFO_EXTENDED = "NewForecastInfoExtended";

    public static final String PHRASES = "phrases";
    public static final String GEO_ID = "geoID";
    public static final String CURRENCY = "currency";
    public static final String CATEGORIES = "categories";
    public static final String PERIOD_TYPE = "periodType";
    public static final String PERIOD_VALUE = "periodValue";
    public static final String AUCTION_BIDS = "auctionBids";
    //endregion

    public NewForecastInfoExtendedMap(String packageName) {
        super(packageName, NEW_FORECAST_INFO_EXTENDED);
    }

    public NewForecastInfoExtendedMap(T newForecastInfoExtended) {
        super();
        setBean(newForecastInfoExtended);
    }

    //region Builder
    public NewForecastInfoExtendedMap withCurrency(String currency) {
        this.put((CURRENCY), currency);
        return this;
    }

    public NewForecastInfoExtendedMap withGeoID(int... geoID) {
        this.put((GEO_ID), geoID);
        return this;
    }

    public NewForecastInfoExtendedMap withCategories(int... categories) {
        this.put((CATEGORIES), categories);
        return this;
    }

    public NewForecastInfoExtendedMap withPhrases(String... phrases) {
        this.put((PHRASES), phrases);
        return this;
    }

    public NewForecastInfoExtendedMap withPeriodType(String periodType) {
        this.put((PERIOD_TYPE), periodType);
        return this;
    }

    public NewForecastInfoExtendedMap withPeriodValue(int periodValue) {
        this.put((PERIOD_VALUE), periodValue);
        return this;
    }

    public NewForecastInfoExtendedMap withAuctionBids(String auctionBids) {
        this.put((AUCTION_BIDS), auctionBids);
        return this;
    }
}
