package ru.yandex.autotests.directapi.model.forecast;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created with IntelliJ IDEA.
 * User: ginger
 * Date: 25.11.13
 * Time: 16:39
 * To change this template use File | Settings | File Templates.
 */
public class NewForecastInfoMap<T> extends ModelBeanMap<NewForecastInfoMap> {
    //region Fields
    private static final String NEW_FORECAST_INFO = "NewForecastInfo";

    public static final String PHRASES = "phrases";
    public static final String GEO_ID = "geoID";
    public static final String CURRENCY = "currency";
    public static final String CATEGORIES = "categories";
    public static final String AUCTION_BIDS = "auctionBids";
    //endregion

    public NewForecastInfoMap(String packageName) {
        super(packageName, NEW_FORECAST_INFO);
    }

    public NewForecastInfoMap(T newForecastInfo) {
        super();
        setBean(newForecastInfo);
    }

    //region Builder
    public NewForecastInfoMap withCurrency(String currency) {
        this.put((CURRENCY), currency);
        return this;
    }

    public NewForecastInfoMap withGeoID(int... geoID) {
        this.put((GEO_ID), geoID);
        return this;
    }

    public NewForecastInfoMap withCategories(int... categories) {
        this.put((CATEGORIES), categories);
        return this;
    }

    public NewForecastInfoMap withPhrases(String... phrases) {
        this.put((PHRASES), phrases);
        return this;
    }

    public NewForecastInfoMap withAuctionBids(String auctionBids) {
        this.put((AUCTION_BIDS), auctionBids);
        return this;
    }

}
