package ru.yandex.autotests.directapi.model.forecast;

import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 25.09.13
 * Time: 0:46
 * To change this template use File | Settings | File Templates.
 */
public class NewWordstatReportInfoMap extends BeanMap {
    //region Fields
    public static final String NEW_WORDSTAT_REPORT_INFO = "NewWordstatReportInfo";
    public static final String PHRASES = "Phrases";
    public static final String GEO_ID = "GeoID";
    public static final String CATEGORIES = "Categories";

    //endregion

    public NewWordstatReportInfoMap(String packageName) {
        super(ReflectionUtils.getInstance(packageName, NEW_WORDSTAT_REPORT_INFO));
    }

    public NewWordstatReportInfoMap clean() {
        clear();
        return this;
    }

    //region Builder

    public NewWordstatReportInfoMap withGeoID(int... geoID) {
        this.put(StringUtils.uncapitalize(GEO_ID), geoID);
        return this;
    }

    public NewWordstatReportInfoMap withPhrases(String... phrases) {
        this.put(StringUtils.uncapitalize(PHRASES), phrases);
        return this;
    }

    public String toString() {
        return JsonUtils.toString(super.getBean());
    }

    public String[] getPhrases() {
        return (String[]) get(StringUtils.uncapitalize(PHRASES));
    }


    //endregion
}
