package ru.yandex.autotests.directapi.model.getchanges;

import org.apache.commons.lang.ArrayUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 23.09.13
 * Time: 13:06
 * To change this template use File | Settings | File Templates.
 */
public class GetChangesRequestMap<T> extends ModelBeanMap<GetChangesRequestMap> {
    //region Fields
    private static final String GET_CHANGES_REQUEST = "GetChangesRequest";

    public static final String CAMPAIGN_IDS = "campaignIDS";
    public static final String BANNER_IDS = "bannerIDS";
    public static final String LOGINS = "logins";
    public static final String TIMESTAMP = "timestamp";
    //endregion

    public GetChangesRequestMap(String packageName) {
        super(packageName, GET_CHANGES_REQUEST);
    }

    public GetChangesRequestMap(T getChangesRequest) {
        super();
        setBean(getChangesRequest);
    }

    //region Builder
    public GetChangesRequestMap withCampaignIDS(int... campaignIDS) {
        this.put((CAMPAIGN_IDS), campaignIDS);
        return this;
    }

    public GetChangesRequestMap withBannerIDS(Long... bannerIDS) {
        this.put((BANNER_IDS), ArrayUtils.toPrimitive(bannerIDS));
        return this;
    }

    public GetChangesRequestMap withLogins(String... logins) {
        this.put((LOGINS), logins);
        return this;
    }

    public GetChangesRequestMap withTimestamp(String timestamp) {
        this.put((TIMESTAMP), timestamp);
        return this;
    }
    //endregion
}
