package ru.yandex.autotests.directapi.model.geteventslog;

import java.util.Date;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 10.10.13
 * Time: 16:44
 * To change this template use File | Settings | File Templates.
 */
public class EventsLogItemAttributesMap<T> extends ModelBeanMap<EventsLogItemAttributesMap> {

    private static final String EVENTS_LOG_ITEM_ATTRIBUTES = "EventsLogItemAttributes";

    public static final String MODERATION_RESULT = "moderationResult";
    public static final String MIN_PRICE = "minPrice";
    public static final String REST = "rest";
    public static final String PAYED = "payed";
    public static final String FINISH_DATE = "finishDate";
    public static final String OLD_PLACE = "oldPlace";
    public static final String IS_EDITED_BY_MODERATOR = "isEditedByModerator";
    public static final String CURRENCY = "currency";
    private static final String STOP_TIME = "stopTime";

    public EventsLogItemAttributesMap(String packageName) {
        super(packageName, EVENTS_LOG_ITEM_ATTRIBUTES);
    }


    public EventsLogItemAttributesMap(T eventsLogItemAttributes) {
        super();
        setBean(eventsLogItemAttributes);
    }


    public EventsLogItemAttributesMap withPayed(Float payed) {
        put(PAYED, payed);
        return this;
    }

    public EventsLogItemAttributesMap withCurrency(Currency currency) {
        String currencyAbbr = (currency != null) ? currency.toString() : null;
        put(CURRENCY, currencyAbbr);
        return this;
    }

    public EventsLogItemAttributesMap withCurrency(String currency) {
        put(CURRENCY, currency);
        return this;
    }

    public EventsLogItemAttributesMap withRest(Float rest) {
        put(REST, rest);
        return this;
    }

    public EventsLogItemAttributesMap withMinPrice(Float minPrice) {
        put(MIN_PRICE, minPrice);
        return this;
    }

    public EventsLogItemAttributesMap withFinishDate(Date finishDate) {
        put(FINISH_DATE, finishDate);
        return this;
    }

    public EventsLogItemAttributesMap withStopTime(String stopTime) {
        put(STOP_TIME, stopTime);
        return this;
    }

    public EventsLogItemAttributesMap withModerationResult(String moderationResult) {
        put(MODERATION_RESULT, moderationResult);
        return this;
    }

    public EventsLogItemAttributesMap withIsEditedByModerator(String isEditedByModerator) {
        put(IS_EDITED_BY_MODERATOR, isEditedByModerator);
        return this;
    }

    public EventsLogItemAttributesMap withOldPlace(String oldPlace) {
        put(OLD_PLACE, oldPlace);
        return this;
    }
}
