package ru.yandex.autotests.directapi.model.geteventslog;

import org.apache.commons.lang.ArrayUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 10.10.13
 * Time: 16:44
 * To change this template use File | Settings | File Templates.
 */
public class GetEventsLogFilterMap<GetEventsLogFilter> extends ModelBeanMap<GetEventsLogFilterMap> {

    private static final String GET_EVENTS_LOG_FILTER = "GetEventsLogFilter";

    public static final String CAMPAIGN_IDS = "campaignIDS";
    public static final String BANNER_IDS = "bannerIDS";
    public static final String ACCOUNT_IDS = "accountIDS";
    public static final String PHRASE_IDS = "phraseIDS";
    public static final String EVENT_TYPE = "eventType";

    public GetEventsLogFilterMap(String packageName) {
        super(packageName, GET_EVENTS_LOG_FILTER);
    }


    public GetEventsLogFilterMap(GetEventsLogFilter getEventsLogFilter) {
        super();
        setBean(getEventsLogFilter);
    }

    public GetEventsLogFilterMap withCampaignIDS(int... campaignIDS) {
        put((CAMPAIGN_IDS), campaignIDS);
        return this;
    }

    public GetEventsLogFilterMap withBannerIDS(Long... bannerIDS) {
        put((BANNER_IDS), ArrayUtils.toPrimitive(bannerIDS));
        return this;
    }

    public GetEventsLogFilterMap withAccountIDS(int... accountIDS) {
        put((ACCOUNT_IDS), accountIDS);
        return this;
    }

    public GetEventsLogFilterMap withPhraseIDS(long... phraseIDS) {
        put((PHRASE_IDS), phraseIDS);
        return this;
    }

    public GetEventsLogFilterMap withEventType(String... eventType) {
        put((EVENT_TYPE), eventType);
        return this;
    }

}
