package ru.yandex.autotests.directapi.model.geteventslog;

import org.apache.commons.lang.StringUtils;

import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 10.10.13
 * Time: 16:44
 * To change this template use File | Settings | File Templates.
 */
public class GetEventsLogRequestMap<GetEventsLogRequest> extends ModelBeanMap<GetEventsLogRequestMap> {

    private static final String GET_EVENTS_LOG_REQUEST = "GetEventsLogRequest";
    public static final String TIMESTAMP_FROM = "timestampFrom";
    public static final String TIMESTAMP_TO = "timestampTo";
    public static final String FILTER = "filter";
    public static final String LOGINS = "logins";
    public static final String LAST_EVENT_ONLY = "lastEventOnly";
    public static final String WITH_TEXT_DESCRIPTION = "withTextDescription";
    public static final String CURRENCY = "currency";
    public static final String LIMIT = "limit";
    public static final String OFFSET = "offset";

    public GetEventsLogRequestMap(String packageName) {
        super();
        Object bean = ReflectionUtils.getInstance(packageName, GET_EVENTS_LOG_REQUEST);
        setBean(bean);
    }

    public GetEventsLogRequestMap(GetEventsLogRequest getEventsLogRequest) {
        super();
        setBean(getEventsLogRequest);
    }


    public GetEventsLogRequestMap withTimestampFrom(String timestampFrom) {
        put(StringUtils.uncapitalize(TIMESTAMP_FROM), timestampFrom);
        return this;
    }

    public GetEventsLogRequestMap withTimestampTo(String timestampFrom) {
        put(StringUtils.uncapitalize(TIMESTAMP_TO), timestampFrom);
        return this;
    }

    public GetEventsLogRequestMap withLastEventOnly(String lastEventOnly) {
        put(StringUtils.uncapitalize(LAST_EVENT_ONLY), lastEventOnly);
        return this;
    }

    public GetEventsLogRequestMap withWithTextDescription(String withTextDescription) {
        put(StringUtils.uncapitalize(WITH_TEXT_DESCRIPTION), withTextDescription);
        return this;
    }

    public GetEventsLogRequestMap withLogins(String... logins) {
        put(StringUtils.uncapitalize(LOGINS), logins);
        return this;
    }

    public GetEventsLogRequestMap withFilter(GetEventsLogFilterMap filter) {
        if (filter != null) {
            put(FILTER, filter.getBean());
        } else {
            put(FILTER, null);
        }
        return this;
    }

    public String toString() {
        return JsonUtils.toString(getBean());
    }

    public GetEventsLogRequestMap withCurrency(String currency) {
        put(StringUtils.uncapitalize(CURRENCY), currency);
        return this;
    }

    public GetEventsLogRequestMap withCurrency(Currency currency) {
        if (currency != null) {
            put(StringUtils.uncapitalize(CURRENCY), currency.value());
        }
        return this;
    }

    public GetEventsLogRequestMap withLimit(Integer limit) {
        put(StringUtils.uncapitalize(LIMIT), limit);
        return this;
    }

    public GetEventsLogRequestMap withOffset(Integer offset) {
        put(StringUtils.uncapitalize(OFFSET), offset);
        return this;
    }
}
