package ru.yandex.autotests.directapi.model.images;

import java.lang.reflect.Array;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.banners.RejectReasonMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by mariabye on 06.02.14.
 */
public class AdImageAssociationMap<T> extends ModelBeanMap<AdImageAssociationMap> {

    private static final String AD_IMAGE_ASSOCIATION = "AdImageAssociation";
    public static final String AD_ID = "adID";
    public static final String AD_IMAGE_HASH = "adImageHash";
    public static final String LOGIN = "login";
    public static final String CAMPAIGN_ID = "campaignID";
    public static final String STATUS_AD_IMAGE_MODERATE = "statusAdImageModerate";
    public static final String MODERATE_REJECTION_REASONS = "moderateRejectionReasons";

    public AdImageAssociationMap(String packageName) {
        super(packageName, AD_IMAGE_ASSOCIATION);
    }

    public AdImageAssociationMap(T adImageAssociation) {
        super();
        setBean(adImageAssociation);
    }

    public AdImageAssociationMap withModerateRejectionReasons(RejectReasonMap... rejectionReasonMaps) {
        Object[] rejectReasons = convert(rejectionReasonMaps, new BeanMapToBeanConverter())
                .toArray((Object[]) Array.newInstance(
                        new RejectReasonMap<>(super.getPackageName()).getBean().getClass(), 0));
        put(MODERATE_REJECTION_REASONS, rejectReasons);
        return this;
    }

    public AdImageAssociationMap withAdID(Long adID) {
        put(AD_ID, adID);
        return this;
    }

    public AdImageAssociationMap withAdImageHash(String adImageHash) {
        put(AD_IMAGE_HASH, adImageHash);
        return this;
    }
}
