package ru.yandex.autotests.directapi.model.images;

import java.lang.reflect.Array;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.apiclient.methods.Action;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by mariabye on 06.02.14.
 */
public class AdImageAssociationRequestMap<T> extends ModelBeanMap<AdImageAssociationRequestMap> {

    private static final String AD_IMAGE_ASSOCIATION_REQUEST = "AdImageAssociationRequest";
    public static final String ACTION = "action";
    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String AD_IMAGE_ASSOCIATIONS = "adImageAssociations";

    public AdImageAssociationRequestMap(String packageName) {
        super(packageName, AD_IMAGE_ASSOCIATION_REQUEST);
    }

    public AdImageAssociationRequestMap(T adImageAssociationSelectionCriteria) {
        super();
        setBean(adImageAssociationSelectionCriteria);
    }

    public AdImageAssociationRequestMap withAction(Action action) {
        this.put((ACTION), action.getAction());
        return this;
    }

    public AdImageAssociationRequestMap withAdImageAssociationSelectionCriteria(
            AdImageAssociationSelectionCriteriaMap selectionCriteria)
    {
        this.put((SELECTION_CRITERIA), selectionCriteria.getBean());
        return this;
    }

    public AdImageAssociationRequestMap withAdImageAssociations(AdImageAssociationMap... adImageAssociationMaps) {
        Object[] adImageAssociations = convert(adImageAssociationMaps, new BeanMapToBeanConverter())
                .toArray((Object[]) Array.newInstance(
                        new AdImageAssociationMap(super.getPackageName()).getBean().getClass(), 0));
        this.put(AD_IMAGE_ASSOCIATIONS, adImageAssociations);
        return this;
    }

    public AdImageAssociationRequestMap get(AdImageAssociationSelectionCriteriaMap selectionCriteria) {
        return this
                .withAction(Action.GET)
                .withAdImageAssociationSelectionCriteria(selectionCriteria);
    }

    public AdImageAssociationRequestMap set(AdImageAssociationMap... adImageAssociationMap) {
        return this
                .withAction(Action.SET)
                .withAdImageAssociations(adImageAssociationMap);
    }
}
