package ru.yandex.autotests.directapi.model.images;

import org.apache.commons.lang.ArrayUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 24.05.13
 * Time: 10:36
 * To change this template use File | Settings | File Templates.
 */
public class AdImageAssociationSelectionCriteriaMap<T> extends ModelBeanMap<AdImageAssociationSelectionCriteriaMap> {

    private static final String AD_IMAGE_ASSOCIATION_SELECTION_CRITERIA = "AdImageAssociationSelectionCriteria";
    public static final String LOGINS = "logins";
    public static final String AD_IDS = "adIDS";
    public static final String AD_IMAGE_HASHES = "adImageHashes";
    public static final String STATUS_AD_IMAGE_MODERATE = "statusAdImageModerate";
    public static final String CAMPAIGN_IDS = "campaignIDS";
    public static final String LIMIT = "limit";
    public static final String OFFSET = "offset";

    public AdImageAssociationSelectionCriteriaMap(String packageName) {
        super(packageName, AD_IMAGE_ASSOCIATION_SELECTION_CRITERIA);
    }

    public AdImageAssociationSelectionCriteriaMap(T adImageAssociationSelectionCriteria) {
        super();
        setBean(adImageAssociationSelectionCriteria);
    }

    public AdImageAssociationSelectionCriteriaMap withLogins(String... logins) {
        this.put(LOGINS, logins);
        return this;
    }

    public AdImageAssociationSelectionCriteriaMap withAdIDS(Long... adIDS) {
        this.put(AD_IDS, ArrayUtils.toPrimitive(adIDS));
        return this;
    }

    public AdImageAssociationSelectionCriteriaMap withAdImageHashes(String... adImageHashes) {
        this.put(AD_IMAGE_HASHES, adImageHashes);
        return this;
    }

    public AdImageAssociationSelectionCriteriaMap withStatusAdImageModerate(String... statusAdImageModerate) {
        this.put(STATUS_AD_IMAGE_MODERATE, statusAdImageModerate);
        return this;
    }

    //TODO @Deprecated
    public AdImageAssociationSelectionCriteriaMap withCampaignIDS(Integer... campaignIDS) {
        this.put(CAMPAIGN_IDS, ArrayUtils.toPrimitive(campaignIDS));
        return this;
    }

    public AdImageAssociationSelectionCriteriaMap withLimit(Integer limit) {
        this.put(LIMIT, limit);
        return this;
    }

    public AdImageAssociationSelectionCriteriaMap withOffset(Integer offset) {
        this.put(OFFSET, offset);
        return this;
    }
}
