package ru.yandex.autotests.directapi.model.images;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by mariabye on 06.02.14.
 */
public class AdImageMap<T> extends ModelBeanMap<AdImageMap> {

    private static final String AD_IMAGE = "AdImage";

    public static final String LOGIN = "login";
    public static final String NAME = "name";
    public static final String AD_IMAGE_HASH = "adImageHash";
    public static final String AD_IMAGE_URL = "adImageURL";
    public static final String ASSIGNED = "assigned";

    public AdImageMap(String packageName) {
        super(packageName, AD_IMAGE);
    }

    public AdImageMap(T adImage) {
        super();
        setBean(adImage);
    }

    public AdImageMap withLogin(String login) {
        put(LOGIN, login);
        return this;
    }

    public AdImageMap withAdImageHash(String adImageHash) {
        put(AD_IMAGE_HASH, adImageHash);
        return this;
    }

    public AdImageMap withAdImageURL(String adImageURL) {
        put(AD_IMAGE_URL, adImageURL);
        return this;
    }

    public AdImageMap withName(String name) {
        put(NAME, name);
        return this;
    }


}
