package ru.yandex.autotests.directapi.model.images;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by mariabye on 06.02.14.
 */
public class AdImageRawMap<T> extends ModelBeanMap<AdImageRawMap> {

    private static final String AD_IMAGE_RAW = "AdImageRaw";

    public static final String LOGIN = "login";
    public static final String RAW_DATA = "rawData";
    public static final String NAME = "name";

    public AdImageRawMap(String packageName) {
        super(packageName, AD_IMAGE_RAW);
    }

    public AdImageRawMap(T adImageAssociation) {
        super();
        setBean(adImageAssociation);
    }

    public AdImageRawMap withLogin(String login) {
        put(LOGIN, login);
        return this;
    }

    public AdImageRawMap withRawData(String rawData) {
        put(RAW_DATA, rawData);
        return this;
    }

    public AdImageRawMap withRawData(byte[] rawData) {
        put(RAW_DATA, new String(rawData));
        return this;
    }

    public AdImageRawMap withName(String name) {
        put(NAME, name);
        return this;
    }


}
