package ru.yandex.autotests.directapi.model.images;

import java.lang.reflect.Array;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.apiclient.methods.Action;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by mariabye on 06.02.14.
 */
public class AdImageRequestMap<T> extends ModelBeanMap<AdImageRequestMap> {

    private static final String AD_IMAGE_REQUEST = "AdImageRequest";

    public static final String ACTION = "action";
    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String AD_IMAGE_RAW_DATA = "adImageRawData";
    public static final String AD_IMAGE_URL_DATA = "adImageURLData";

    public AdImageRequestMap(String packageName) {
        super(packageName, AD_IMAGE_REQUEST);
    }

    public AdImageRequestMap(T adImageRequest) {
        super();
        setBean(adImageRequest);
    }

    public AdImageRequestMap withAction(Action action) {
        this.put((ACTION), action.getAction());
        return this;
    }

    public AdImageRequestMap withAdImageSelectionCriteria(AdImageSelectionCriteriaMap selectionCriteria) {
        this.put((SELECTION_CRITERIA), selectionCriteria.getBean());
        return this;
    }

    public AdImageRequestMap withAdImageRawData(AdImageRawMap... adImageRawMaps) {
        Object[] adImageRaws = convert(adImageRawMaps, new BeanMapToBeanConverter())
                .toArray((Object[]) Array.newInstance(
                        new AdImageRawMap(super.getPackageName()).getBean().getClass(), 0));
        this.put(AD_IMAGE_RAW_DATA, adImageRaws);
        return this;
    }

    public AdImageRequestMap withAdImageURL(AdImageURLMap... adImageURLMaps) {
        Object[] adImageURLs = convert(adImageURLMaps, new BeanMapToBeanConverter())
                .toArray((Object[]) Array.newInstance(
                        new AdImageURLMap(super.getPackageName()).getBean().getClass(), 0));
        this.put(AD_IMAGE_URL_DATA, adImageURLs);
        return this;
    }

    public AdImageRequestMap getLimits(AdImageSelectionCriteriaMap adImageSelectionCriteriaMap) {
        return this
                .withAction(Action.GET_LIMITS)
                .withAdImageSelectionCriteria(adImageSelectionCriteriaMap);
    }

    public AdImageRequestMap upload(AdImageURLMap... adImageURLMaps) {
        return this
                .withAction(Action.UPLOAD)
                .withAdImageURL(adImageURLMaps);
    }

    public AdImageRequestMap uploadRawData(AdImageRawMap... imageRaws) {
        return this
                .withAction(Action.UPLOAD_RAW_DATA)
                .withAdImageRawData(imageRaws);
    }

    public AdImageRequestMap checkUploadStatus(AdImageSelectionCriteriaMap adImageSelectionCriteriaMap) {
        return this.withAction(Action.CHECK_UPLOAD_STATUS)
                .withAdImageSelectionCriteria(adImageSelectionCriteriaMap);
    }

    public AdImageRequestMap delete(AdImageSelectionCriteriaMap adImageSelectionCriteriaMap) {
        return this.withAction(Action.DELETE)
                .withAdImageSelectionCriteria(adImageSelectionCriteriaMap);
    }

    public AdImageRequestMap getImage(AdImageSelectionCriteriaMap adImageSelectionCriteriaMap) {
        return this.withAction(Action.GET)
                .withAdImageSelectionCriteria(adImageSelectionCriteriaMap);
    }
}
