package ru.yandex.autotests.directapi.model.images;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 24.05.13
 * Time: 10:36
 * To change this template use File | Settings | File Templates.
 */
public class AdImageSelectionCriteriaMap<T> extends ModelBeanMap<AdImageSelectionCriteriaMap> {

    private static final String AD_IMAGE_SELECTION_CRITERIA = "AdImageSelectionCriteria";
    public static final String LOGINS = "logins";
    public static final String AD_IMAGE_UPLOAD_TASK_IDS = "adImageUploadTaskIDS";
    public static final String AD_IMAGE_HASHES = "adImageHashes";
    public static final String ASSIGNED = "assigned";
    public static final String LIMIT = "limit";
    public static final String OFFSET = "offset";

    public AdImageSelectionCriteriaMap(String packageName) {
        super(packageName, AD_IMAGE_SELECTION_CRITERIA);
    }

    public AdImageSelectionCriteriaMap(T adImageSelectionCriteria) {
        super();
        setBean(adImageSelectionCriteria);
    }

    public AdImageSelectionCriteriaMap withLogins(String... logins) {
        this.put(LOGINS, logins);
        return this;
    }

    public AdImageSelectionCriteriaMap withAdImageUploadTaskIDS(int... adImageUploadTaskIDS) {
        this.put(AD_IMAGE_UPLOAD_TASK_IDS, adImageUploadTaskIDS);
        return this;
    }

    public AdImageSelectionCriteriaMap withAdImageHashes(String... adImageHashes) {
        this.put(AD_IMAGE_HASHES, adImageHashes);
        return this;
    }

    public AdImageSelectionCriteriaMap withAssigned(String... assigned) {
        this.put(ASSIGNED, assigned);
        return this;
    }

    public AdImageSelectionCriteriaMap withLimit(Integer limit) {
        this.put(LIMIT, limit);
        return this;
    }

    public AdImageSelectionCriteriaMap withOffset(Integer offset) {
        this.put(OFFSET, offset);
        return this;
    }
}
