package ru.yandex.autotests.directapi.model.images;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by mariabye on 06.02.14.
 */
public class AdImageURLMap<T> extends ModelBeanMap<AdImageURLMap> {

    private static final String AD_IMAGE_URL = "AdImageURL";

    public static final String LOGIN = "login";
    public static final String URL = "URL";
    public static final String NAME = "name";

    public AdImageURLMap(String packageName) {
        super(packageName, AD_IMAGE_URL);
    }

    public AdImageURLMap(T adImageAssociation) {
        super();
        setBean(adImageAssociation);
    }

    public AdImageURLMap withLogin(String login) {
        put(LOGIN, login);
        return this;
    }

    public AdImageURLMap withURL(String url) {
        put(URL, url);
        return this;
    }

    public AdImageURLMap withName(String name) {
        put(NAME, name);
        return this;
    }
}
