package ru.yandex.autotests.directapi.model.images;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.ErrorMap;

/**
 * Created by mariabye on 06.02.14.
 */
public class AdImageUploadMap<T> extends ModelBeanMap<AdImageUploadMap> {

    private static final String AD_IMAGE_UPLOAD = "AdImageUpload";

    public static final String LOGIN = "login";
    public static final String NAME = "name";
    public static final String AD_IMAGE_HASH = "adImageHash";
    public static final String AD_IMAGE_URL = "adImageURL";
    public static final String AD_IMAGE_UPLOAD_TASK_ID = "adImageUploadTaskID";
    public static final String SOURCE_URL = "sourceURL";
    public static final String STATUS = "status";
    public static final String ERROR = "error";

    public AdImageUploadMap(String packageName) {
        super(packageName, AD_IMAGE_UPLOAD);
    }

    public AdImageUploadMap(T adImageUpload) {
        super();
        setBean(adImageUpload);
    }

    public AdImageUploadMap withLogin(String login) {
        put(LOGIN, login);
        return this;
    }

    public AdImageUploadMap withAdImageHash(String adImageHash) {
        put(AD_IMAGE_HASH, adImageHash);
        return this;
    }

    public AdImageUploadMap withAdImageUploadTaskID(Integer adImageUploadTaskID) {
        put(AD_IMAGE_UPLOAD_TASK_ID, adImageUploadTaskID);
        return this;
    }

    public AdImageUploadMap withAdImageURL(String adImageURL) {
        put(AD_IMAGE_URL, adImageURL);
        return this;
    }

    public AdImageUploadMap withSourceURL(String sourceURL) {
        put(SOURCE_URL, sourceURL);
        return this;
    }

    public AdImageUploadMap withName(String name) {
        put(NAME, name);
        return this;
    }

    public AdImageUploadMap withStatus(String pending) {
        put(STATUS, pending);
        return this;
    }

    public AdImageUploadMap withError(ErrorMap error) {
        put(ERROR, error.getBean());
        return this;
    }
}
