package ru.yandex.autotests.directapi.model.prices;

import org.apache.commons.lang.ArrayUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 19.09.13
 * Time: 17:17
 * To change this template use File | Settings | File Templates.
 */
public class AutoPriceInfoMap<T> extends ModelBeanMap<AutoPriceInfoMap> {
    //region Fields
    private static final String AUTO_PRICE_INFO = "AutoPriceInfo";

    public static final String BANNER_IDS = "bannerIDS";
    public static final String PHRASE_IDS = "phraseIDS";
    public static final String CAMPAIGN_ID = "campaignID";
    public static final String MODE = "mode";
    public static final String PRICE = "price";
    public static final String CONTEXT_PRICE = "contextPrice";
    public static final String BANNERS_TYPE = "bannersType";
    public static final String PRICE_BASE = "priceBase";
    public static final String DONT_WAIT_FOR_PRICE_UPDATE = "dontWaitForPriceUpdate";
    public static final String PHRASES_TYPE = "phrasesType";
    public static final String CURRENCY = "currency";
    public static final String SCOPE = "scope";
    public static final String SINGLE_PRICE = "singlePrice";
    public static final String PROC_BASE = "procBase";
    public static final String PROC = "proc";
    public static final String MAX_PRICE = "maxPrice";
    public static final String UPDATE_CATEGORIES = "updateCategories";
    //endregion

    public static final int MAXIMUM_BANNER_IDS_LENGTH = 1000;
    public static final int MAXIMUM_PHRASE_IDS_LENGTH = 2000;
    public static final int MINIMUM_PROC_VALUE = 0;
    public static final int MAXIMUM_PROC_VALUE = 1000;
    public static final int MINIMUM_SCOPE_VALUE = 1;
    public static final int MAXIMUM_SCOPE_VALUE = 100;

    public AutoPriceInfoMap(String packageName) {
        super(packageName, AUTO_PRICE_INFO);
    }

    public AutoPriceInfoMap(T autoPriceInfo) {
        super();
        setBean(autoPriceInfo);
    }

    //region Builder
    public AutoPriceInfoMap withSinglePriceMode() {
        this.put((MODE), Mode.SINGLE_PRICE);
        return this;
    }

    public AutoPriceInfoMap withWizardMode() {
        this.put((MODE), Mode.WIZARD);
        return this;
    }

    public AutoPriceInfoMap withBannerIDS(Long... bannerIDS) {
        this.put((BANNER_IDS), ArrayUtils.toPrimitive(bannerIDS));
        return this;
    }

    public AutoPriceInfoMap withPhraseIDS(long... phraseIDS) {
        this.put((PHRASE_IDS), phraseIDS);
        return this;
    }

    public AutoPriceInfoMap withCampaignID(Integer campaignID) {
        this.put((CAMPAIGN_ID), campaignID);
        return this;
    }

    public AutoPriceInfoMap withCampaignID(Long campaignID) {
        return withCampaignID(campaignID.intValue());
    }

    public AutoPriceInfoMap withPrice(Float price) {
        this.put((PRICE), price);
        return this;
    }

    public AutoPriceInfoMap withContextPrice(Float contextPrice) {
        this.put((CONTEXT_PRICE), contextPrice);
        return this;
    }

    public AutoPriceInfoMap withBannersType(String type) {
        this.put((BANNERS_TYPE), type);
        return this;
    }

    public AutoPriceInfoMap withPriceBase(String priceBase) {
        this.put((PRICE_BASE), priceBase);
        return this;
    }

    public AutoPriceInfoMap withCampaignID(int campaignID) {
        this.put((CAMPAIGN_ID), campaignID);
        return this;
    }

    public AutoPriceInfoMap withDontWaitForPriceUpdate(String value) {
        this.put((DONT_WAIT_FOR_PRICE_UPDATE), value);
        return this;
    }

    public AutoPriceInfoMap withPhrasesType(String value) {
        this.put((PHRASES_TYPE), value);
        return this;
    }

    public AutoPriceInfoMap withCurrency(String value) {
        this.put((CURRENCY), value);
        return this;
    }

    public AutoPriceInfoMap withCurrency(Currency currency) {
        if (currency != null && currency != Currency.YND_FIXED) {
            this.put((CURRENCY), currency.value());
        } else {
            this.put((CURRENCY), null);
        }
        return this;
    }

    public AutoPriceInfoMap withScope(int value) {
        this.put((SCOPE), value);
        return this;
    }

    public AutoPriceInfoMap withSinglePrice(Float price) {
        this.put((SINGLE_PRICE), price);
        return this;
    }

    public AutoPriceInfoMap withProc(int value) {
        this.put((PROC), value);
        return this;
    }

    public AutoPriceInfoMap withProcBase(String value) {
        this.put((PROC_BASE), value);
        return this;
    }

    public AutoPriceInfoMap withMaxPrice(Float price) {
        this.put((MAX_PRICE), price);
        return this;
    }

    public AutoPriceInfoMap withUpdateCategories(String value) {
        this.put((UPDATE_CATEGORIES), value);
        return this;
    }
    //endregion
}
