package ru.yandex.autotests.directapi.model.prices;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 20.09.13
 * Time: 15:06
 * To change this template use File | Settings | File Templates.
 */
public class PhrasePriceInfoMap<T> extends ModelBeanMap<PhrasePriceInfoMap> {
    private static final String PHRASE_PRICE_INFO = "PhrasePriceInfo";

    //region Fields
    public static final String PHRASE_ID = "phraseID";
    public static final String CAMPAIGN_ID = "campaignID";
    public static final String PRICE = "price";
    public static final String CONTEXT_PRICE = "contextPrice";
    public static final String CURRENCY = "currency";
    public static final String AUTO_BUDGET_PRIORITY = "autoBudgetPriority";
    public static final String AUTO_BROKER = "autoBroker";
    //endregion

    public PhrasePriceInfoMap(String packageName) {
        super(packageName, PHRASE_PRICE_INFO);
    }

    public PhrasePriceInfoMap(T phrasePriceInfo) {
        super();
        setBean(phrasePriceInfo);
    }

    //region Builder
    public PhrasePriceInfoMap withPhraseID(Integer phraseID) {
        this.put((PHRASE_ID), phraseID);
        return this;
    }

    public PhrasePriceInfoMap withPhraseID(Long phraseID) {
        this.put((PHRASE_ID), phraseID);
        return this;
    }

    public PhrasePriceInfoMap withCampaignID(Integer campaignID) {
        this.put((CAMPAIGN_ID), campaignID);
        return this;
    }

    public PhrasePriceInfoMap withPrice(Float price) {
        this.put((PRICE), price);
        return this;
    }

    public PhrasePriceInfoMap withContextPrice(Float contextPrice) {
        this.put((CONTEXT_PRICE), contextPrice);
        return this;
    }

    public PhrasePriceInfoMap withCurrency(Currency currency) {
        if (currency != null && currency != Currency.YND_FIXED) {
            this.put((CURRENCY), currency.value());
        } else {
            this.put((CURRENCY), null);
        }
        return this;
    }

    public PhrasePriceInfoMap withAutoBudgetPriority(String autoBudgetPriority) {
        this.put((AUTO_BUDGET_PRIORITY), autoBudgetPriority);
        return this;
    }

    public PhrasePriceInfoMap withAutoBroker(String autoBroker) {
        this.put((AUTO_BROKER), autoBroker);
        return this;
    }
    //endregion
}
