package ru.yandex.autotests.directapi.model.retargeting;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by mariabye on 06.02.14.
 */
public class RetargetingConditionGoalItemMap<T> extends ModelBeanMap<RetargetingConditionGoalItemMap> {

    private static final String RETARGETING_CONDITION_GOAL_ITEM = "RetargetingConditionGoalItem";
    public static final String TIME = "time";
    public static final String GOAL_ID = "goalID";

    public static final int MAX_TIME = 90;

    public RetargetingConditionGoalItemMap(String packageName) {
        super(packageName, RETARGETING_CONDITION_GOAL_ITEM);
    }

    public RetargetingConditionGoalItemMap(T retargetingConditionGoalItem) {
        super();
        setBean(retargetingConditionGoalItem);
    }

    public RetargetingConditionGoalItemMap withTime(int time) {
        put(TIME, time);
        return this;
    }

    public RetargetingConditionGoalItemMap withGoalID(long goalID) {
        put(GOAL_ID, goalID);
        return this;
    }
}
