package ru.yandex.autotests.directapi.model.retargeting;

import java.lang.reflect.Array;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.irt.testutils.RandomUtils;

import static ch.lambdaj.Lambda.convert;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 15.08.13
 * Time: 14:51
 * To change this template use File | Settings | File Templates.
 */
public class RetargetingConditionItemMap<T> extends ModelBeanMap<RetargetingConditionItemMap> {


    private static final String RETARGETING_CONDITION_ITEM = "RetargetingConditionItem";
    public static final String TYPE = "type";
    public static final String GOALS = "goals";

    public RetargetingConditionItemMap(String packageName) {
        super(packageName, RETARGETING_CONDITION_ITEM);
    }

    public RetargetingConditionItemMap(T retargetingConditionItem) {
        super();
        setBean(retargetingConditionItem);
    }

    public RetargetingConditionItemMap withType(String type) {
        put(TYPE, type);
        return this;
    }

    public RetargetingConditionItemMap withRandomType() {
        String[] types = new String[]{
                RetargetingType.ALL.toString(),
                RetargetingType.OR.toString()
        };
        return withType(types[RandomUtils.getRandomInteger(0, 2)]);
    }

    public RetargetingConditionItemMap withType(RetargetingType type) {
        return withType(type.toString());
    }

    public RetargetingConditionItemMap withGoals(RetargetingConditionGoalItemMap... goalMaps) {
        if (goalMaps != null) {
            Object[] goals = convert(goalMaps, new BeanMapToBeanConverter<>())
                    .toArray((Object[]) Array.newInstance(
                            new RetargetingConditionGoalItemMap<>(super.getPackageName()).getBean().getClass(), 0));
            put(GOALS, goals);
        } else {
            put(GOALS, null);
        }
        return this;
    }
}
