package ru.yandex.autotests.directapi.model.retargeting;

import java.lang.reflect.Array;

import org.apache.commons.lang.RandomStringUtils;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * User: mariabye
 * Date: 24.05.13
 */
public class RetargetingConditionMap<T> extends ModelBeanMap<RetargetingConditionMap> {

    private static final String RETARGETING_CONDITION_CLASS = "RetargetingCondition";

    public static final String LOGIN = "login";
    public static final String RETARGETING_CONDITION_NAME = "retargetingConditionName";
    public static final String RETARGETING_CONDITION_ID = "retargetingConditionID";
    public static final String RETARGETING_CONDITION_DESCRIPTION = "retargetingConditionDescription";
    public static final String RETARGETING_CONDITION = "retargetingCondition";
    public static final String IS_ACCESSIBLE = "isAccessible";
    public static final String FIELDS = "fields";

    public RetargetingConditionMap(String packageName) {
        super(packageName, RETARGETING_CONDITION_CLASS);
    }

    public RetargetingConditionMap(T retargetingCondition) {
        super();
        setBean(retargetingCondition);
    }

    public RetargetingConditionMap defaultRetargeting(String login) {
        return withLogin(login)
                .withRetargetingConditionName("Условие ретаргетинга " + RandomStringUtils.randomAlphanumeric(5))
                .withRetargetingConditionDescription("Тестовое условие ретаргетинга");
    }

    public RetargetingConditionMap withIsAccessible(String isAccessible) {
        put(IS_ACCESSIBLE, isAccessible);
        return this;
    }

    public RetargetingConditionMap withFields(String... fields) {
        put(FIELDS, fields);
        return this;
    }

    public RetargetingConditionMap withLogin(String login) {
        put(LOGIN, login);
        return this;
    }

    public RetargetingConditionMap withRetargetingConditionID(int retargetingConditionID) {
        put(RETARGETING_CONDITION_ID, retargetingConditionID);
        return this;
    }

    public RetargetingConditionMap withRetargetingConditionName(String retargetingConditionName) {
        put(RETARGETING_CONDITION_NAME, retargetingConditionName);
        return this;
    }

    public RetargetingConditionMap withRetargetingConditionDescription(String retargetingConditionDescription) {
        put(RETARGETING_CONDITION_DESCRIPTION, retargetingConditionDescription);
        return this;
    }

    public RetargetingConditionMap withRetargetingConditionItems(
            RetargetingConditionItemMap... retargetingConditionMaps)
    {
        if (retargetingConditionMaps != null) {
            Object[] retargetingConditions = convert(retargetingConditionMaps, new BeanMapToBeanConverter<>())
                    .toArray((Object[]) Array.newInstance(
                            new RetargetingConditionItemMap<>(super.getPackageName()).getBean().getClass(), 0));
            put(RETARGETING_CONDITION, retargetingConditions);
        } else {
            put(RETARGETING_CONDITION, null);
        }
        return this;
    }

}
