package ru.yandex.autotests.directapi.model.retargeting;

import java.lang.reflect.Array;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.apiclient.methods.Action;

import static ch.lambdaj.Lambda.convert;


/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 04.12.13
 * Time: 13:20
 * To change this template use File | Settings | File Templates.
 */
public class RetargetingConditionRequestMap<T> extends ModelBeanMap<RetargetingConditionRequestMap> {

    private static final String RETARGETING_CONDITION_REQUEST = "RetargetingConditionRequest";

    public static final String ACTION = "action";
    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String RETARGETING_CONDITIONS = "retargetingConditions";

    public RetargetingConditionRequestMap(String packageName) {
        super(packageName, RETARGETING_CONDITION_REQUEST);
    }

    public RetargetingConditionRequestMap(T retargetingConditionRequest) {
        super();
        setBean(retargetingConditionRequest);
    }

    public RetargetingConditionRequestMap withAction(Action action) {
        put(ACTION, action.getAction());
        return this;
    }


    public RetargetingConditionRequestMap withSelectionCriteria(
            RetargetingConditionSelectionCriteriaMap retargetingConditionSelectionCriteriaMap)
    {
        put(SELECTION_CRITERIA, retargetingConditionSelectionCriteriaMap.getBean());
        return this;
    }

    public RetargetingConditionRequestMap withRetargetingConditions(
            RetargetingConditionMap... retargetingConditionMaps)
    {
        if (retargetingConditionMaps != null) {
            Object[] retargetingConditions = convert(retargetingConditionMaps, new BeanMapToBeanConverter())
                    .toArray((Object[]) Array.newInstance(
                            new RetargetingConditionMap<>(super.getPackageName()).getBean().getClass(), 0));
            this.put(RETARGETING_CONDITIONS, retargetingConditions);
        } else {
            this.put(RETARGETING_CONDITIONS, null);
        }
        return this;
    }
}
