package ru.yandex.autotests.directapi.model.retargeting;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by mariabye on 06.02.14.
 */
public class RetargetingGoalMap<T> extends ModelBeanMap<RetargetingGoalMap> {

    private static final String RETARGETING_GOAL = "RetargetingGoal";
    public static final String GOAL_ID = "goalID";
    public static final String NAME = "name";
    public static final String GOAL_DOMAIN = "goalDomain";
    public static final String LOGIN = "login";
    public static final String TYPE = "type";


    public RetargetingGoalMap(String packageName) {
        super(packageName, RETARGETING_GOAL);
    }

    public RetargetingGoalMap(T retargetingGoal) {
        super();
        setBean(retargetingGoal);
    }

    public RetargetingGoalMap withGoalID(long goalID) {
        this.put((GOAL_ID), goalID);
        return this;
    }


    public RetargetingGoalMap withName(String name) {
        this.put((NAME), name);
        return this;
    }


    public RetargetingGoalMap withGoalDomain(String goalDomain) {
        this.put((GOAL_DOMAIN), goalDomain);
        return this;
    }


    public RetargetingGoalMap withLogin(String login) {
        this.put((LOGIN), login);
        return this;
    }


    public RetargetingGoalMap withType(String type) {
        this.put((TYPE), type);
        return this;
    }

}
