package ru.yandex.autotests.directapi.model.retargeting;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * User: mariabye
 * Date: 24.05.13
 */
public class RetargetingMap<T> extends ModelBeanMap<RetargetingMap> {
    public static final String RETARGETING = "Retargeting";

    public static final String CURRENCY = "currency";
    public static final String AD_ID = "adID";
    public static final String RETARGETING_CONDITION_ID = "retargetingConditionID";
    public static final String CONTEXT_PRICE = "contextPrice";
    public static final String AUTO_BUDGET_PRIORITY = "autoBudgetPriority";
    public static final String STATUS_PAUSED = "statusPaused";
    public static final String FIELDS = "fields";
    public static final String RETARGETING_ID = "retargetingID";
    public static final String AD_GROUP_ID = "adGroupID";

    public RetargetingMap(String packageName) {
        super(packageName, RETARGETING);
    }

    public RetargetingMap(T retargeting) {
        super();
        setBean(retargeting);
    }

    public RetargetingMap withRetargetingID(Integer retargetingID) {
        put(RETARGETING_ID, retargetingID);
        return this;
    }

    public RetargetingMap withAdID(Long adID) {
        put(AD_ID, adID);
        return this;
    }

    public RetargetingMap withRetargetingConditionID(Integer retargetingConditionID) {
        put(RETARGETING_CONDITION_ID, retargetingConditionID);
        return this;
    }


    public RetargetingMap withContextPrice(Float contextPrice) {
        put(CONTEXT_PRICE, contextPrice);
        return this;
    }

    public RetargetingMap withAutoBudgetPriority(String autoBudgetPriority) {
        put(AUTO_BUDGET_PRIORITY, autoBudgetPriority);
        return this;
    }

    public RetargetingMap withCurrency(String currency) {
        put(CURRENCY, currency);
        return this;
    }

    public RetargetingMap withStatusPaused(String statusPaused) {
        put(STATUS_PAUSED, statusPaused);
        return this;
    }

    public RetargetingMap withFields(String... fields) {
        put(FIELDS, fields);
        return this;
    }

    public RetargetingMap withCurrency(Currency currency) {
        if (currency != null) {
            return withCurrency(currency.value());
        }
        return this;
    }

    public RetargetingMap withAdGroupID(Long adGroupID) {
        put(AD_GROUP_ID, adGroupID);
        return this;
    }
}
