package ru.yandex.autotests.directapi.model.retargeting;

import java.lang.reflect.Array;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.apiclient.methods.Action;

import static ch.lambdaj.Lambda.convert;


/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 04.12.13
 * Time: 13:20
 * To change this template use File | Settings | File Templates.
 */
public class RetargetingRequestMap<T> extends ModelBeanMap<RetargetingRequestMap> {

    private static final String RETARGETING_REQUEST = "RetargetingRequest";
    public static final String ACTION = "action";
    public static final String LOGIN = "login";
    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String OPTIONS = "options";
    public static final String RETARGETINGS = "retargetings";

    public RetargetingRequestMap(String packageName) {
        super(packageName, RETARGETING_REQUEST);
    }

    public RetargetingRequestMap(T retargetingRequest) {
        super();
        setBean(retargetingRequest);
    }

    public RetargetingRequestMap withAction(Action action) {
        put(ACTION, action.getAction());
        return this;
    }

    public RetargetingRequestMap withLogin(String login) {
        put(LOGIN, login);
        return this;
    }

    public RetargetingRequestMap withSelectionCriteria(RetargetingSelectionCriteriaMap selectionCriteria) {
        put(SELECTION_CRITERIA, selectionCriteria.getBean());
        return this;
    }

    public RetargetingRequestMap withOptions(RetargetingRequestOptionsMap options) {
        if (options != null) {
            put(OPTIONS, options.getBean());
        } else {
            put(OPTIONS, null);
        }
        return this;
    }

    public RetargetingRequestMap withRetargetings(RetargetingMap... retargetingMaps) {
        if (retargetingMaps != null) {
            Object[] retargetings = convert(retargetingMaps, new BeanMapToBeanConverter())
                    .toArray((Object[]) Array.newInstance(
                            new RetargetingMap<>(super.getPackageName()).getBean().getClass(), 0));
            this.put(RETARGETINGS, retargetings);
        } else {
            this.put(RETARGETINGS, null);
        }
        return this;
    }
}
