package ru.yandex.autotests.directapi.model.retargeting;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created by mariabye on 06.02.14.
 */
public class RetargetingRequestOptionsMap<T> extends ModelBeanMap<RetargetingGoalMap> {

    private static final String RETARGETING_REQUEST_OPTIONS = "RetargetingRequestOptions";
    public static final String CURRENCY = "currency";

    public RetargetingRequestOptionsMap(String packageName) {
        super(packageName, RETARGETING_REQUEST_OPTIONS);
    }

    public RetargetingRequestOptionsMap(T retargetingRequestOptions) {
        super();
        setBean(retargetingRequestOptions);
    }

    public RetargetingRequestOptionsMap withCurrency(String currency) {
        put(CURRENCY, currency);
        return this;
    }


    public RetargetingRequestOptionsMap withCurrency(Currency currency) {
        if (currency != null) {
            return withCurrency(currency.value());
        }
        return this;
    }
}
