package ru.yandex.autotests.directapi.model.retargeting;

import org.apache.commons.lang.ArrayUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by mariabye on 06.02.14.
 */
public class RetargetingSelectionCriteriaMap<T> extends ModelBeanMap<RetargetingSelectionCriteriaMap> {

    public static final int MAX_AD_IDS_LENGTH = 1000;
    public static final int MAX_RETARGETING_IDS_LENGTH = 1000;
    public static final int MAX_RETARGETING_CONDITION_IDS_LENGTH = 1000;

    public static final String RETARGETING_SELECTION_CRITERIA = "RetargetingSelectionCriteria";

    public static final String RETARGETING_CONDITION_IDS = "retargetingConditionIDS";
    public static final String AD_IDS = "adIDS";
    public static final String RETARGETING_IDS = "retargetingIDS";

    public RetargetingSelectionCriteriaMap(String packageName) {
        super(packageName, RETARGETING_SELECTION_CRITERIA);
    }

    public RetargetingSelectionCriteriaMap(T retargetingSelectionCriteria) {
        super();
        setBean(retargetingSelectionCriteria);
    }

    public RetargetingSelectionCriteriaMap withAdIDs(Long... adIDs) {
        put(AD_IDS, ArrayUtils.toPrimitive(adIDs));
        return this;
    }

    public RetargetingSelectionCriteriaMap withRetargetingIDS(int... retargetingIDS) {
        put(RETARGETING_IDS, retargetingIDS);
        return this;
    }

    public RetargetingSelectionCriteriaMap withRetargetingConditionIDS(int... retargetingConditionIDS) {
        put(RETARGETING_CONDITION_IDS, retargetingConditionIDS);
        return this;
    }
}
