package ru.yandex.autotests.directapi.model.statistics;

import java.util.Date;

import org.joda.time.DateTime;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 09.10.13
 * Time: 21:24
 * To change this template use File | Settings | File Templates.
 */
public class GetSummaryStatRequestMap<T> extends ModelBeanMap<GetSummaryStatRequestMap> {
    //region Fields
    private static final String GET_SUMMARY_STAT_REQUEST = "GetSummaryStatRequest";

    public static final String CAMPAIGN_IDS = "campaignIDS";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private static final String CURRENCY = "currency";
    public static String INCLUDE_VAT = "includeVAT";
    public static String INCLUDE_DISCOUNT = "includeDiscount";
    //endregion

    public GetSummaryStatRequestMap(String packageName) {
        super(packageName, GET_SUMMARY_STAT_REQUEST);
    }

    public GetSummaryStatRequestMap(T getSummaryStatRequest) {
        super();
        setBean(getSummaryStatRequest);
    }

    //region Builder
    public GetSummaryStatRequestMap withCampaignIDS(int... campaignIDS) {
        this.put((CAMPAIGN_IDS), campaignIDS);
        return this;
    }

    public GetSummaryStatRequestMap withStartDate(Date startDate) {
        this.put((START_DATE), startDate);
        return this;
    }

    public GetSummaryStatRequestMap withEndDate(Date endDate) {
        this.put((END_DATE), endDate);
        return this;
    }

    public GetSummaryStatRequestMap defaultPeriod() {
        return this.withStartDate(DateTime.now().minusDays(1).toDate()).withEndDate(DateTime.now().toDate());
    }

    public GetSummaryStatRequestMap withCurrency(String currency) {
        this.put((CURRENCY), currency);
        return this;
    }

    public GetSummaryStatRequestMap withIncludeVAT(String includeVAT) {
        put((INCLUDE_VAT), includeVAT);
        return this;
    }

    public GetSummaryStatRequestMap withIncludeDiscount(String includeDiscount) {
        put((INCLUDE_DISCOUNT), includeDiscount);
        return this;
    }
    //endregion
}
