package ru.yandex.autotests.directapi.model.statistics;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 25.12.13
 * Time: 17:19
 * To change this template use File | Settings | File Templates.
 */
public class KeywordIntersectionRequestMap<T> extends ModelBeanMap<KeywordIntersectionRequestMap> {

    private static final String KEYWORD_INTERSECTION_REQUEST = "KeywordIntersectionRequest";

    public static final String KEYWORDS = "keywords";
    public static final String WITH_KEYWORDS = "withKeywords";
    public static final String WITH_CAMPAIGN_IDS = "withCampaignIDS";
    public static final String CAMPAIGN_IDS = "campaignIDS";

    public KeywordIntersectionRequestMap(String packageName) {
        super(packageName, KEYWORD_INTERSECTION_REQUEST);
    }

    public KeywordIntersectionRequestMap(T keywordIntersectionRequest) {
        super();
        setBean(keywordIntersectionRequest);
    }

    public KeywordIntersectionRequestMap withKeywords(String... keywords) {
        put((KEYWORDS), keywords);
        return this;
    }

    public KeywordIntersectionRequestMap withWithKeywords(String... withKeywords) {
        put((WITH_KEYWORDS), withKeywords);
        return this;
    }

    public KeywordIntersectionRequestMap withCampaignIDS(int... campaignIDS) {
        put((CAMPAIGN_IDS), campaignIDS);
        return this;
    }

    public KeywordIntersectionRequestMap withWithCampaignIDS(int... withCampaignIDS) {
        put((WITH_CAMPAIGN_IDS), withCampaignIDS);
        return this;
    }
}
