package ru.yandex.autotests.directapi.model.statistics;

import org.apache.commons.lang.ArrayUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 12.12.13
 * Time: 13:18
 * To change this template use File | Settings | File Templates.
 */
public class NewReportFilterInfoMap<T> extends ModelBeanMap<NewReportFilterInfoMap> {

    private static final String NEW_REPORT_FILTER_INFO = "NewReportFilterInfo";

    public static final String WITH_IMAGE = "withImage";
    public static final String BANNER = "banner";
    public static final String POSITION_TYPE = "positionType";
    public static final String PAGE_TYPE = "pageType";
    public static final String PAGE_NAME = "pageName";
    public static final String PHRASE = "phrase";
    public static final String GEO = "geo";
    public static final String STAT_GOALS = "statGoals";
    public static final String DEVICE_TYPE = "deviceType";
    public static final String AGE = "age";
    public static final String GENDER = "gender";
    public static final String CARRIER_TYPE = "carrierType";
    public static final String MOBILE_PLATFORM = "mobilePlatform";

    public static final Integer PHRASE_MAX_LENGTH = 4096;

    public NewReportFilterInfoMap(String packageName) {
        super(packageName, NEW_REPORT_FILTER_INFO);
    }

    public NewReportFilterInfoMap(T newReportFilterInfo) {
        super();
        setBean(newReportFilterInfo);
    }

    /**
     * Only one goal allowed
     *
     * @param goalId
     * @return
     */
    public NewReportFilterInfoMap withStatGoals(int... goalId) {
        put((STAT_GOALS), goalId);
        return this;
    }

    public NewReportFilterInfoMap withWithImages(String value) {
        put((WITH_IMAGE), value);
        return this;
    }

    public NewReportFilterInfoMap withBanner(Long... bannerIDS) {
        put((BANNER), ArrayUtils.toPrimitive(bannerIDS));
        return this;
    }

    public NewReportFilterInfoMap withPositionType(String type) {
        put((POSITION_TYPE), type);
        return this;
    }

    public NewReportFilterInfoMap withPageName(String... pageName) {
        put((PAGE_NAME), pageName);
        return this;
    }

    public NewReportFilterInfoMap withPageType(String pageType) {
        put((PAGE_TYPE), pageType);
        return this;
    }

    public NewReportFilterInfoMap withPhrase(String... phrase) {
        put((PHRASE), phrase);
        return this;
    }

    public NewReportFilterInfoMap withGeo(int... geo) {
        put((GEO), geo);
        return this;
    }

    public NewReportFilterInfoMap withDeviceType(String deviceType) {
        put((DEVICE_TYPE), deviceType);
        return this;
    }

    public NewReportFilterInfoMap withAge(String... age) {
        put((AGE), age);
        return this;
    }

    public NewReportFilterInfoMap withGender(String... gender) {
        put((GENDER), gender);
        return this;
    }

    public NewReportFilterInfoMap withCarrierType(String... carrierType) {
        put((CARRIER_TYPE), carrierType);
        return this;
    }

    public NewReportFilterInfoMap withMobilePlatform(String... mobilePlatform) {
        put((MOBILE_PLATFORM), mobilePlatform);
        return this;
    }
}
