package ru.yandex.autotests.directapi.model.statistics;

import java.util.Date;

import org.joda.time.DateTime;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.common.api45.NewReportInfo;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 25.09.13
 * Time: 0:46
 * To change this template use File | Settings | File Templates.
 */
public class NewReportInfoMap<T> extends ModelBeanMap<NewReportInfoMap> {
    //region Fields
    private static final String NEW_REPORT_INFO = "NewReportInfo";

    public static String CAMPAIGN_ID = "campaignID";
    public static String START_DATE = "startDate";
    public static String END_DATE = "endDate";
    public static String GROUP_BY_COLUMNS = "groupByColumns";
    public static String FILTER = "filter";
    public static String LIMIT = "limit";
    public static String OFFSET = "offset";
    public static String GROUP_BY_DATE = "groupByDate";
    public static String ORDER_BY = "orderBy";
    public static String TYPE_RESULT_REPORT = "typeResultReport";
    public static String COMPRESS_REPORT = "compressReport";
    public static String CURRENCY = "currency";
    public static String INCLUDE_VAT = "includeVAT";
    public static String INCLUDE_DISCOUNT = "includeDiscount";
    public static String XML = "xml";
    //endregion

    public static Double UAH_CURRENCY_RATE_TO_09_2014 = 8.1;
    public static Double UAH_CURRENCY_RATE_FROM_09_2014_TO_04_2015 = 12.0;
    public static Double USD_CURRENCY_RATE_TO_12_2014 = 0.85;
    public static Double USD_CURRENCY_RATE_TO_04_2015 = 0.41;

    public NewReportInfoMap(String packageName) {
        super(packageName, NEW_REPORT_INFO);
    }

    public NewReportInfoMap(T newReportInfo) {
        super();
        setBean(newReportInfo);
    }

    //region Builder
    public NewReportInfoMap withCampaignID(Integer campaignID) {
        this.put((CAMPAIGN_ID), campaignID);
        return this;
    }

    public NewReportInfoMap withStartDate(Date startDate) {
        this.put((START_DATE), startDate);
        return this;
    }

    public NewReportInfoMap withEndDate(Date endDate) {
        this.put((END_DATE), endDate);
        return this;
    }

    public NewReportInfoMap withOrderBy(String... orderBy) {
        this.put((ORDER_BY), orderBy);
        return this;
    }

    public NewReportInfoMap withGroupByColumns(String... groupByColumns) {
        this.put((GROUP_BY_COLUMNS), groupByColumns);
        return this;
    }

    public String[] getGroupByColumns() {
        return (String[]) get((GROUP_BY_COLUMNS));
    }

    public NewReportInfoMap withLimit(Integer limit) {
        put((LIMIT), limit);
        return this;
    }

    public NewReportInfoMap withOffset(Integer offset) {
        put((OFFSET), offset);
        return this;
    }

    public NewReportInfoMap parse(String reportinfo) {
        setBean(JsonUtils.getObject(reportinfo, NewReportInfo.class));
        return this;
    }


    public NewReportInfoMap defaultPeriod() {
        return this.withStartDate(DateTime.parse("2017-12-01").toDate())
                .withEndDate(DateTime.parse("2017-12-07").toDate());
    }

    public NewReportInfoMap withTypeResultReport(String typeResultReport) {
        put((TYPE_RESULT_REPORT), typeResultReport);
        return this;
    }

    public NewReportInfoMap withFilter(NewReportFilterInfoMap filterInfoMap) {
        if (filterInfoMap != null) {
            put((FILTER), filterInfoMap.getBean());
        } else {
            put((FILTER), null);
        }
        return this;
    }

    public NewReportInfoMap withCurrency(String currency) {
        put((CURRENCY), currency);
        return this;
    }

    public NewReportInfoMap withIncludeVAT(String includeVAT) {
        put((INCLUDE_VAT), includeVAT);
        return this;
    }

    public NewReportInfoMap withIncludeDiscount(String includeDiscount) {
        put((INCLUDE_DISCOUNT), includeDiscount);
        return this;
    }

    public NewReportInfoMap withGroupByDate(String date) {
        put((GROUP_BY_DATE), date);
        return this;
    }

    public NewReportInfoMap withStartDate(String startDate) {
        return withStartDate(DateTime.parse(startDate).toDate());
    }

    public NewReportInfoMap withEndDate(String endDate) {
        return withEndDate(DateTime.parse(endDate).toDate());
    }

    public NewReportInfoMap withCompressReport(int compressReport) {
        put((COMPRESS_REPORT), compressReport);
        return this;
    }
    //endregion
}
