package ru.yandex.autotests.directapi.model.statistics;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.google.gson.annotations.SerializedName;

import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created by ginger on 05.10.15.
 */
public class OfflineReportData {

    List<ReportLine> reportLines;

    public OfflineReportData(String tsv) {
        reportLines = new ArrayList<>();
        if (tsv.startsWith("\uFEFF")) {  //https://st.yandex-team.ru/DIRECT-45396#1444126649000
            tsv = tsv.substring(1);
        }
        tsv = tsv.replace("\r", "").replace("\n\"", "\n");
        String[] tsvLines = tsv.replace("\"\n", "\n").split("\n");
        Pattern pattern = Pattern.compile(
                "(.*)\t(.*)\t(\\d+)\t(.*)\t(\\d+)\t(\\d+)\t(.*)\t(.*)\t(.*)\t(.*)\t(\\d+)\t(\\d+)\t(\\d?.+)?\t(\\d?.+)\t(\\d?.+)?\t(\\d?.+)?\t(\\d?.+)?\t(\\d?.+)?\t(\\d+)");
        for (String line : tsvLines) {
            if ((line != null) && !line.startsWith("Date")) {
                Matcher matcher = pattern.matcher(line);
                if (matcher.matches()) {
                    ReportLine reportLine = new ReportLine();
                    reportLine.setDate(matcher.group(1));
                    reportLine.setCampaignName(matcher.group(2));
                    reportLine.setCampaignId(Long.valueOf(matcher.group(3)));
                    reportLine.setAdGroupName(matcher.group(4));
                    reportLine.setAdGroupId(Long.valueOf(matcher.group(5)));
                    reportLine.setAdId(Long.valueOf(matcher.group(6)));
                    reportLine.setTitle(matcher.group(7));
                    reportLine.setText(matcher.group(8));
                    reportLine.setUrl(matcher.group(9));
                    reportLine.setSearchQuery(matcher.group(10));
                    reportLine.setImpressions(Integer.valueOf(matcher.group(11)));
                    reportLine.setClicks(Integer.valueOf(matcher.group(12)));
                    if (matcher.group(13) == null) {
                        reportLine.setCTR(null);
                    } else {
                        reportLine.setCTR(Double.valueOf(matcher.group(13)));
                    }
                    reportLine.setCost(Double.valueOf(matcher.group(14)));
                    if (matcher.group(15) == null) {
                        reportLine.setAvgClickCost(null);
                    } else {
                        reportLine.setAvgClickCost(Double.valueOf(matcher.group(15)));
                    }
                    if (matcher.group(16) == null) {
                        reportLine.setAvgDepth(null);
                    } else {
                        reportLine.setAvgDepth(Double.valueOf(matcher.group(16)));
                    }
                    if (matcher.group(17) == null) {
                        reportLine.setConversion(null);
                    } else {
                        reportLine.setConversion(Double.valueOf(matcher.group(17)));
                    }
                    if (matcher.group(18) == null) {
                        reportLine.setAvgGoalCost(null);
                    } else {
                        reportLine.setAvgGoalCost(Double.valueOf(matcher.group(18)));
                    }
                    reportLine.setGoalsNum(Integer.valueOf(matcher.group(19)));
                    reportLines.add(reportLine);
                } else {
                    throw new DarkSideException("Ошибка парсинга ответа: не удалось распарсить строку " + line);
                }
            }
        }
    }

    public List<ReportLine> getReportLines() {
        return reportLines;
    }

    public static class ReportLine {

        @SerializedName("Date")
        private String date;

        @SerializedName("CampaignName")
        private String campaignName;

        @SerializedName("CampaignId")
        private Long campaignId;

        @SerializedName("AdGroupName")
        private String adGroupName;

        @SerializedName("AdGroupId")
        private Long adGroupId;

        @SerializedName("AdId")
        private Long adId;

        @SerializedName("Title")
        private String title;

        @SerializedName("Text")
        private String text;

        @SerializedName("Url")
        private String url;

        @SerializedName("SearchQuery")
        private String searchQuery;

        @SerializedName("Impressions")
        private Integer impressions;

        @SerializedName("Clicks")
        private Integer clicks;

        @SerializedName("CTR")
        private Double CTR;

        @SerializedName("Cost")
        private Double cost;

        @SerializedName("CostCurrency")
        private Double costCurrency;

        @SerializedName("AvgClickCost")
        private Double avgClickCost;

        @SerializedName("AvgDepth")
        private Double avgDepth;

        @SerializedName("Conversion")
        private Double conversion;

        @SerializedName("AvgGoalCost")
        private Double avgGoalCost;

        @SerializedName("GoalsNum")
        private Integer goalsNum;

        public String getDate() {
            return date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public Long getCampaignId() {
            return campaignId;
        }

        public void setCampaignId(Long campaignId) {
            this.campaignId = campaignId;
        }

        public String getCampaignName() {
            return campaignName;
        }

        public void setCampaignName(String campaignName) {
            this.campaignName = campaignName;
        }

        public String getAdGroupName() {
            return adGroupName;
        }

        public void setAdGroupName(String adGroupName) {
            this.adGroupName = adGroupName;
        }

        public Long getAdGroupId() {
            return adGroupId;
        }

        public void setAdGroupId(Long adGroupId) {
            this.adGroupId = adGroupId;
        }

        public Long getAdId() {
            return adId;
        }

        public void setAdId(Long adId) {
            this.adId = adId;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getText() {
            return text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Integer getImpressions() {
            return impressions;
        }

        public void setImpressions(Integer impressions) {
            this.impressions = impressions;
        }

        public Integer getClicks() {
            return clicks;
        }

        public void setClicks(Integer clicks) {
            this.clicks = clicks;
        }

        public String getSearchQuery() {
            return searchQuery;
        }

        public void setSearchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
        }

        public Double getCTR() {
            return CTR;
        }

        public void setCTR(Double CTR) {
            this.CTR = CTR;
        }

        public Double getCost() {
            return cost;
        }

        public void setCost(Double cost) {
            this.cost = cost;
        }

        public Double getAvgClickCost() {
            return avgClickCost;
        }

        public void setAvgClickCost(Double avgClickCost) {
            this.avgClickCost = avgClickCost;
        }

        public Double getAvgDepth() {
            return avgDepth;
        }

        public void setAvgDepth(Double avgDepth) {
            this.avgDepth = avgDepth;
        }

        public Double getConversion() {
            return conversion;
        }

        public void setConversion(Double conversion) {
            this.conversion = conversion;
        }

        public Double getAvgGoalCost() {
            return avgGoalCost;
        }

        public void setAvgGoalCost(Double avgGoalCost) {
            this.avgGoalCost = avgGoalCost;
        }

        public Integer getGoalsNum() {
            return goalsNum;
        }

        public void setGoalsNum(Integer goalsNum) {
            this.goalsNum = goalsNum;
        }

        @Override
        public String toString() {
            return JsonUtils.toString(this);
        }
    }

}
