package ru.yandex.autotests.directapi.model.statistics;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 05.10.15.
 */
public class OfflineReportInfoMap<T> extends ModelBeanMap<OfflineReportInfoMap> {
    public class OfflineReportInfo {
        private Integer id;
        private String status;
        private String url;

        public int getId() {
            return id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getStatus() {
            return status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static final String ID = "id";
    public static final String STATUS = "status";
    public static final String URL = "url";

    public OfflineReportInfoMap() {
        super();
        setBean(new OfflineReportInfo());
    }

    //region Builder
    public OfflineReportInfoMap withID(int id) {
        this.put((ID), id);
        return this;
    }

    public OfflineReportInfoMap withStatus(String status) {
        this.put((STATUS), status);
        return this;
    }

    public OfflineReportInfoMap withUrl(String url) {
        this.put((URL), url);
        return this;
    }

    //endregion


}
