package ru.yandex.autotests.directapi.model.statistics;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 27.01.14
 * Time: 10:53
 * To change this template use File | Settings | File Templates.
 */
public class RearrangeKeywordsRequestMap<T> extends ModelBeanMap<RearrangeKeywordsRequestMap> {
    private static final String REARRANGE_KEYWORD_REQUEST = "RearrangeKeywordsRequest";

    public static final String KEYWORDS = "keywords";
    public static final String AUTO_MINUS_WORDS = "autoMinusWords";

    public RearrangeKeywordsRequestMap(String packageName) {
        super(packageName, REARRANGE_KEYWORD_REQUEST);
    }

    public RearrangeKeywordsRequestMap(T rearrangeKeywordsRequest) {
        super();
        setBean(rearrangeKeywordsRequest);
    }

    public RearrangeKeywordsRequestMap withKeywords(String... keywords) {
        put((KEYWORDS), keywords);
        return this;
    }

    public RearrangeKeywordsRequestMap withAutoMinusWords(String yesNoValue) {
        put((AUTO_MINUS_WORDS), yesNoValue);
        return this;
    }
}
