package ru.yandex.autotests.directapi.model.statistics;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 08.07.15.
 */
public class RowMap<T> extends ModelBeanMap<RowMap> {
    private static final String ROW = "Row";

    public static final String SHOWS = "shows";
    public static final String CLICKS = "clicks";
    public static final String SUM = "sum";


    public RowMap(String packageName) {
        super(packageName, ROW);
    }

    public RowMap(T row) {
        super();
        setBean(row);
    }

    //region Builder
    public RowMap withShows(Integer shows) {
        this.put((SHOWS), shows);
        return this;
    }

    public RowMap withClicks(Integer clicks) {
        this.put((CLICKS), clicks);
        return this;
    }

    public RowMap withSum(Float sum) {
        this.put((SUM), sum);
        return this;
    }

}
