package ru.yandex.autotests.directapi.model.subscription;

import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.direct.utils.model.Locale;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.model.geteventslog.EventType;

/**
 * @author xy6er
 */
public class SubscriptionMap<Subscription> extends BeanMap {
    public static final String SUBSCRIPTION = "Subscription";
    public static final String SUBSCRIPTION_TYPE = "SubscriptionType";
    public static final String SUBSCRIPTION_RESOURCE = "SubscriptionResource";
    public static final String TIMEOUT = "Timeout";
    public static final String LOCALE = "Locale";
    public static final String EVENT_TYPES = "EventTypes";
    public static final String OPTIONS = "Options";

    public static final String SUBSCRIPTION_TYPE_APNS = "APNS";
    public static final String IPAD_TOKEN = "b14001fad297a91463e93a5c32bba0a43f6fadd11a8ffed14a6e5550271687d4";
    public static final String TEST_PUSH_TOKEN = "6a12278a5d082b7578f9cde9dde511394a875dd016e00a17d0e478a4f7ae8fe1";
    public static final String SHARD_TOKEN = "c6512e5e587a6455af33a939dad07db077aa81947fe33c198e877c062c6727e8";
    public static final String ANNA_HOME_PUSH_TOKEN =
            "430f6e8479ff9bfb4bbe2b6f3485ecabe17fe9fc27813153f09d604a040c9e33";
    public static final String
            TOKEN_FOR_NOT_EXIST_SUBSCRIPTION = "a12341fad297a91463e93a5c32bba0a43f6fadd11a8ffed14a6e555027165678";

    public static final String[] ALL_EVENT_TYPES = new String[]{
            EventType.MONEYIN,
            EventType.MONEYOUT,
            EventType.BANNERMODERATED,
            EventType.CAMPAIGNFINISHED,
            EventType.MONEYWARNING,
            EventType.WARNMINPRICE,
            EventType.WARNPLACE,
            EventType.LOWCTR,
            EventType.PAUSEDBYDAYBUDGET
    };

    public SubscriptionMap(String packageName) {
        super(ReflectionUtils.getInstance(packageName, SUBSCRIPTION));
    }

    public SubscriptionMap(Subscription subscription) {
        super(subscription);
    }

    //region Builder
    public SubscriptionMap defaultSubscription() {
        this.withSubscriptionType(SUBSCRIPTION_TYPE_APNS);
        this.withTimeout(2);
        this.withLocale(Locale.RUSSIAN.getName());
        this.withEventTypes(ALL_EVENT_TYPES);
        this.withOptions("ru.yandex.direct.inhouse");
        return this;
    }

    public SubscriptionMap getSubscriptionFor(String... eventTypes) {
        this.withSubscriptionType(SUBSCRIPTION_TYPE_APNS);
        this.withTimeout(1); // минута
        this.withLocale(Locale.RUSSIAN.getName());
        this.withEventTypes(eventTypes);
        this.withOptions(null);
        return this;
    }

    public SubscriptionMap withSubscriptionType(String subscriptionType) {
        this.put(StringUtils.uncapitalize(SUBSCRIPTION_TYPE), subscriptionType);
        return this;
    }

    public SubscriptionMap withSubscriptionResource(String subscriptionResource) {
        this.put(StringUtils.uncapitalize(SUBSCRIPTION_RESOURCE), subscriptionResource);
        return this;
    }

    public SubscriptionMap withTimeout(Integer timeout) {
        this.put(StringUtils.uncapitalize(TIMEOUT), timeout);
        return this;
    }

    public SubscriptionMap withLocale(String locale) {
        this.put(StringUtils.uncapitalize(LOCALE), locale);
        return this;
    }

    public SubscriptionMap withEventTypes(String... eventTypes) {
        this.put(StringUtils.uncapitalize(EVENT_TYPES), eventTypes);
        return this;
    }

    public SubscriptionMap withOptions(String options) {
        this.put(StringUtils.uncapitalize(OPTIONS), options);
        return this;
    }

    @Override
    public SubscriptionMap clone() {
        try {
            return (SubscriptionMap) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new DirectAPIException("Failed to clone SubscriptionMap", e);
        }
    }

    //endregion
}
