package ru.yandex.autotests.directapi.model.subscription;

import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.autotests.direct.utils.ReflectionUtils;

/**
 * @author xy6er
 */
public class SubscriptionShortMap<SubscriptionShort> extends BeanMap {
    public static final String SUBSCRIPTION_SHORT = "SubscriptionShort";
    public static final String SUBSCRIPTION_TYPE = SubscriptionMap.SUBSCRIPTION_TYPE;
    public static final String SUBSCRIPTION_RESOURCE = SubscriptionMap.SUBSCRIPTION_RESOURCE;

    public SubscriptionShortMap(String packageName) {
        super(ReflectionUtils.getInstance(packageName, SUBSCRIPTION_SHORT));
    }

    public SubscriptionShortMap(SubscriptionShort subscriptionShort) {
        super(subscriptionShort);
    }

    public SubscriptionShortMap(SubscriptionMap subscriptionMap) {
        super(ReflectionUtils.getInstance(
                subscriptionMap.getBean().getClass().getPackage().getName(), SUBSCRIPTION_SHORT));
        this.withSubscriptionType(
                (String) subscriptionMap.get(StringUtils.uncapitalize(SubscriptionMap.SUBSCRIPTION_TYPE)));
        this.withSubscriptionResource(
                (String) subscriptionMap.get(StringUtils.uncapitalize(SubscriptionMap.SUBSCRIPTION_RESOURCE)));
    }

    //region Builder
    public SubscriptionShortMap withSubscriptionType(String subscriptionType) {
        this.put(StringUtils.uncapitalize(SUBSCRIPTION_TYPE), subscriptionType);
        return this;
    }

    public SubscriptionShortMap withSubscriptionResource(String subscriptionResource) {
        this.put(StringUtils.uncapitalize(SUBSCRIPTION_RESOURCE), subscriptionResource);
        return this;
    }
    //endregion
}
