package ru.yandex.autotests.directapi.rules;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.autotests.irt.testutils.allure.LogSteps;

/**
 * Created by semkagtn on 1/29/15.
 */
public class Api5Bin<T> {

    private LogSteps log = LogSteps.getLogger(this.getClass());
    private Api5Binable<T> steps;
    private Map<T, String> bin;

    public Api5Bin(Api5Binable<T> steps) {
        this.steps = steps;
        openBin();
    }

    public void openBin() {
        bin = new HashMap<>();
    }

    /**
     * Adds trash to bin if its called in non-static test method
     *
     * @param trash
     */
    public void throwToBin(T trash, String login) {
        if (bin != null) {
            bin.put(trash, login);
        }
    }

    public void clearBin() {
        try {
            steps.clearBin(bin).call();
        } catch (Exception exception) {
            log.info("Не удалось очистить тестовые данные: ", exception);
        }
        bin.clear();
    }

    public void removeFromBin(T trash) {
        if (bin != null && bin.containsKey(trash)) {
            bin.remove(trash);
        }
    }

    public Map<T, String> getBin() {
        return bin;
    }
}
