package ru.yandex.autotests.directapi.rules;

import java.util.HashSet;
import java.util.Set;

import ru.yandex.autotests.irt.testutils.allure.LogSteps;

/**
 * Created by mariabye on 14.02.14.
 */
public class Bin<T> {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private Binable<T> steps;
    private Set<T> bin;

    public Bin(Binable<T> steps) {
        this.steps = steps;
        openBin();
    }

    public void openBin() {
        bin = new HashSet<>();
    }

    /**
     * Adds trash to bin if its called in non-static test method
     *
     * @param trash
     */
    public void throwToBin(T trash) {
        if (bin != null) {
            bin.add(trash);
        }
    }

    public void clearBin() {
        try {
            steps.clearBin(bin).call();
        } catch (Exception exception) {
            log.info("Не удалось очистить тестовые данные: ", exception);
        }
        bin.clear();
    }

    public void removeFromBin(T trash) {
        if (bin != null && bin.contains(trash)) {
            bin.remove(trash);
        }
    }

    public Set<T> getBin() {
        return bin;
    }
}
